******************************************************
* ROTATE.SRC                                         *
*                                                    *
* This program performs a few simple operations with *
* the switches and LEDs attached to the 68681 ports. *
* The program turns on one LED and then rotates its  *
* position left or right at a variable frequency.    *
* Input switches control the program as follows:     *
*                                                    *
*        IP1    IP0     Frequency of Rotation        *
*        ====================================        *
*         0      0            1 Hz                   *
*         0      1            2 Hz                   *
*         1      0            4 Hz                   *
*         1      1            8 Hz                   *
*                                                    *
*        IP2            Direction of Rotation        *
*        ====================================        *
*         0                   left                   *
*         1                   right                  *
******************************************************
DUART    EQU      $00C001     ;68681 base address
IPR      EQU      13*2        ;input port reg.
OPR_SET  EQU      14*2        ;set bit command reg.
OPR_CLR  EQU      15*2        ;clear bit cmd. reg.
ONE_SEC  EQU      204800      ;1 sec. delay count
* NOTE: 3686400 / 18 / 204800 = 1 Hz

         ORG      $8000
ROTATE   MOVEA.L  #DUART,A0         ;point to 68681
         MOVE.B   #$FE,D0           ;begin at LED #0
LOOP9    BSR.S    OUT681            ;update LEDs
         MOVE.B   IPR(A0),D1        ;read switches
         ANDI.W   #3,D1             ;chck IP0/IP1 1st
         ROL.B    #2,D1             ;long word align
         MOVE.L   COUNT(PC,D1.W),D7 ;get delay count
         BSR.S    DELAY             ;delay
         MOVE.B   IPR(A0),D1        ;read switches
         BTST     #2,D1             ;test bit #2 (IP2)
         BEQ.S    LEFT              ;IP2 = 1?
RIGHT    ROR.B    #1,D0             ;no:  rotate right
         BRA      LOOP9
LEFT     ROL.B    #1,D0             ;yes: rotate left
         BRA      LOOP9

* Create look-up table for counts
COUNT    DC.L     ONE_SEC        ;1 Hz (1 sec. delay)
         DC.L     ONE_SEC/2      ;2 Hz
         DC.L     ONE_SEC/4      ;4 Hz
         DC.L     ONE_SEC/8      ;8 Hz

******************************************************
* DELAY - create a software DELAY using D7 as count  *
*                                                    *
*        ENTER:   D7[0:31] = count                   *
*        EXIT:    D7[0:31] = 0                       *
*                 all other registers intact         *
*        USES:    no subroutines                     *
*                                                    *
* NOTE: If the 68000 is operating from a 3.6864 MHz  *
* crystal, the delay equals COUNT x 18/3686400 sec.  *
******************************************************
DELAY    SUBQ.L   #1,D7    ;8 cycles
         BNE      DELAY    ;10 cycles (branch taken)
         RTS

******************************************************
* OUT681 - OUTput data to 68681 output port          *
*                                                    *
*        ENTER:   D0[0:7] contains data to output    *
*                 A0 points to 68681 DUART           *
*        EXIT:    all registers intact               *
*        USES:    no subroutines                     *
******************************************************
OUT681   MOVE.B   D0,OPR_CLR(A0) ;clr. bits, set pins
         NOT.B    D0
         MOVE.B   D0,OPR_SET(A0) ;set bits, clr. pins
         NOT.B    D0             ;restore D0
         RTS
         END       ROTATE
